/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.parts;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.internal.action.Program;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class InfoPanel
implements Part {
    private Boolean border = null;
    private String icon = null;
    private String url = null;
    private String title = null;
    private String text = null;
    private String comment = null;
    private String tooltip = null;
    private de.willuhn.jameica.gui.util.Color fgColor = null;
    private Composite comp = null;
    private List<Button> buttons = new LinkedList<Button>();

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setBorder(Boolean b) {
        this.border = b;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public void addButton(Button button) {
        this.buttons.add(button);
    }

    public void setForeground(de.willuhn.jameica.gui.util.Color color) {
        this.fgColor = color;
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        boolean borderlessOS;
        if (this.comp != null) {
            return;
        }
        Color bg = null;
        int border = 0;
        int os = Application.getPlatform().getOS();
        boolean bl = borderlessOS = os == 2 || os == 5 || os == 3;
        if (this.border != null && this.border.booleanValue() || this.border == null && !borderlessOS) {
            bg = GUI.getDisplay().getSystemColor(25);
            border = 2048;
        }
        this.comp = new Composite(parent, border);
        this.comp.setBackground(bg);
        this.comp.setBackgroundMode(2);
        this.comp.setLayoutData((Object)new GridData(768));
        this.comp.setLayout((Layout)new GridLayout(2, false));
        int rows = 5;
        if (this.url != null && this.url.length() > 0) {
            ++rows;
        }
        GridData gd = new GridData(34);
        gd.verticalSpan = rows;
        Label icon = new Label(this.extend(DrawState.ICON_BEFORE, this.comp, null), 0);
        icon.setBackground(bg);
        icon.setLayoutData((Object)gd);
        if (this.icon != null && this.icon.length() > 0) {
            Image image = SWTUtil.getImage(this.icon);
            icon.setImage(image);
        }
        this.extend(DrawState.ICON_AFTER, this.comp, icon);
        Label title = new Label(this.extend(DrawState.TITLE_BEFORE, this.comp, null), 0);
        title.setBackground(bg);
        title.setLayoutData((Object)new GridData(768));
        title.setFont(Font.H2.getSWTFont());
        if (this.fgColor != null) {
            title.setForeground(this.fgColor.getSWTColor());
        }
        title.setText(this.title != null ? this.title : "");
        this.extend(DrawState.TITLE_AFTER, this.comp, title);
        Label desc = new Label(this.extend(DrawState.TEXT_BEFORE, this.comp, null), 64);
        desc.setBackground(bg);
        if (this.fgColor != null) {
            desc.setForeground(this.fgColor.getSWTColor());
        }
        desc.setLayoutData((Object)new GridData(768));
        desc.setText(this.text != null ? this.text : "");
        this.extend(DrawState.TEXT_AFTER, this.comp, desc);
        if (this.url != null && this.url.length() > 0) {
            Link l = new Link(this.extend(DrawState.LINK_BEFORE, this.comp, null), 0);
            l.setBackground(bg);
            l.setLayoutData((Object)new GridData(768));
            if (this.fgColor != null) {
                l.setForeground(this.fgColor.getSWTColor());
            }
            l.setText("<A>" + this.url + "</A>");
            l.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        new Program().handleAction(InfoPanel.this.url);
                    }
                    catch (ApplicationException ae) {
                        Application.getMessagingFactory().sendMessage(new StatusBarMessage(ae.getMessage(), 1));
                    }
                }
            });
            this.extend(DrawState.LINK_AFTER, this.comp, l);
        }
        Label comment = new Label(this.extend(DrawState.COMMENT_BEFORE, this.comp, null), 64);
        comment.setBackground(bg);
        comment.setFont(Font.SMALL.getSWTFont());
        comment.setForeground(de.willuhn.jameica.gui.util.Color.COMMENT.getSWTColor());
        comment.setLayoutData((Object)new GridData(768));
        comment.setText(this.comment != null ? this.comment : "");
        if (this.tooltip != null) {
            comment.setToolTipText(this.tooltip);
        }
        this.extend(DrawState.COMMENT_AFTER, this.comp, comment);
        Composite c = this.extend(DrawState.BUTTONS_BEFORE, this.comp, null);
        ButtonArea buttons = new ButtonArea();
        for (Button b : this.buttons) {
            buttons.addButton(b);
        }
        buttons.paint(c);
        this.extend(DrawState.BUTTONS_AFTER, c, buttons);
    }

    public Composite extend(DrawState state, Composite comp, Object context) {
        return comp;
    }

    public Composite getComposite() {
        return this.comp;
    }

    public void dispose() {
        try {
            if (this.comp == null || this.comp.isDisposed()) {
                return;
            }
            SWTUtil.disposeChildren(this.comp);
            this.comp.dispose();
        }
        finally {
            this.comp = null;
        }
    }

    public static enum DrawState {
        ICON_BEFORE,
        ICON_AFTER,
        TITLE_BEFORE,
        TITLE_AFTER,
        TEXT_BEFORE,
        TEXT_AFTER,
        LINK_BEFORE,
        LINK_AFTER,
        COMMENT_BEFORE,
        COMMENT_AFTER,
        BUTTONS_BEFORE,
        BUTTONS_AFTER;

    }
}

